//Program 8: Simple content based image retrieval using various distance metrics.
//Based on Similarity matrix
//Using Colormaps of different images
//Note 1: Other methods like wavelet based decomposition along with Euclidean distance 
//comparison of sub images can be used for image retrieval
//Note 2: Principal Component Analysis (PCA) inbuilt function is available to
//get eigen vectors and eigen values for image retrieval
//Software version
//OS Windows7
//Scilab5.4.1
//Image Processing Design Toolbox 8.3.1-1
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2
clear;
clc;
close;
I1 = imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\Picture1.png');//257x257x3.
I1 = imresize(I1,0.5);
[IndexedImage_I1, ColorMap] = RGB2Ind(I1); //IPD toolbox
I = ColorMap;//66049x3
J1 = imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\Picture2.png');//257x257x3.
J1 = imresize(J1,0.5);
[IndexedImage_J1, ColorMap] = RGB2Ind(J1); //IPD toolbox
J = ColorMap;//66049x3
//Similarity Matrix Method 
[r,c]= size(I);
A = [];
I = double(I);
J = double(J);
for i = 1:r
    for j = 1:c
        M1(i,j) = (I(i,2)*sin(I(i,1))-J(j,2)*sin(J(j,1)))^2;
        M2(i,j) = (I(i,2)*cos(I(i,1))-J(j,2)*cos(J(j,1)))^2;
        M3(i,j) = (I(i,3)-J(i,3))^2;
        M(i,j)= sqrt(M1(i,j)+M2(i,j)+M3(i,j));
        A(i,j) = 1-M(i,j)/sqrt(5);
    end
end
I1_rec = Ind2RGB(IndexedImage_I1,A)
I1_rec = imresize(I1_rec,2);
J1_rec = Ind2RGB(IndexedImage_J1,A)
J1_rec = imresize(J1_rec,2);
figure
ShowColorImage(I1,'original first image');
figure
ShowColorImage(I1_rec,'Reconstructed first image');
figure
ShowColorImage(J1,'original second image');
figure
ShowColorImage(J1_rec,'Reconstructed second image');
